$(document).ready(function () {
    // 1. 定义基础元素
    const html = document.querySelector('html');
    const $button = $('#wheel__btn');
    const $spinner = $('#wheel__spinner');
    const $popup = $('#popup');
    const $popupWindow1 = $('#popup__window1');

    // 2. 强制添加 .en 类，防止 CSS 隐藏文字
    html.classList.add('en');

    // 3. 隐藏预加载动画 (Preloader)
    const hidePreloader = () => {
        html.classList.remove('hide');
        setTimeout(function () {
            html.classList.add('hide');
        }, 1000);
    };
    hidePreloader();

    // 4. 按钮点击事件 (核心逻辑)
    // 使用 .off() 防止重复绑定，优先绑定确保可点击
    $button.off('click').on('click', () => {
        // 禁用按钮，防止重复点击
        $button.addClass('disabled');
        $button.css('pointer-events', 'none'); 

        // 切换动画类名：移除待机动画，添加旋转动画
        $spinner.addClass('wheel__spinner_animated_1');
        $spinner.removeClass('wheel__spinner_animated');

        // 4秒后显示弹窗
        setTimeout(function () {
            // 显示弹窗背景和内容
            $popup.addClass('popup__show');
            $popupWindow1.addClass('popup__window_show');
            
            // 锁定转盘视觉位置 (1080度)
            $spinner.removeClass('wheel__spinner_animated_1');
            $spinner.css('transform', 'rotate(1080deg)');
        }, 4000);
    });

    // 5. 货币设置 (主要修改在这里：设置为 RM)
    try {
        const country = html.getAttribute('data-country') || 'default';
        
        // 这里定义显示的金额和货币
        const data = {
            // 将默认值修改为 RM (您可以把 3000 改成您想要的数字)
            default: { countWB: '3000 RM' }, 
            
            // 因为 HTML 头部默认是 data-country="nl"，所以把这个也改成 RM
            nl: { countWB: '3000 RM' },
            
            // 添加马来西亚代码
            my: { countWB: '3000 RM' },
            
            // 如果还需要保留其他国家的特殊货币，可以写在下面，否则都会使用 default 的 RM
            // pl: { countWB: '5000 PLN' },
        };

        // 获取对应数据，如果没有则使用 default
        const selectedData = data[country] ? data[country] : data.default;
        const inputValue = selectedData.countWB;

        // 将金额填充到页面上的 .bonus-full 元素中
        if (inputValue) {
            const fullBonusElems = document.querySelectorAll('.bonus-full');
            fullBonusElems.forEach(el => {
                el.textContent = inputValue;
            });
        }
    } catch (error) {
        console.warn("Currency logic skipped due to error:", error);
    }

    // 6. 自动更新页脚年份
    $('#year').text(new Date().getFullYear());

    // 7. 文字特效初始化 (用于标题渐变等)
    const textEffect = document.querySelectorAll('.text-effect span');
    textEffect.forEach(el => {
        el.setAttribute('data-text', el.textContent);
    });

    // 8. 下雪背景特效 (Snow Effect)
    if (typeof particlesJS !== 'undefined') {
        particlesJS('particles-js', {
            particles: {
                number: {
                    value: 150, // 雪花数量
                    density: { enable: true, value_area: 800 }
                },
                color: { value: '#ffffff' }, // 雪花颜色
                shape: {
                    type: 'circle',
                    stroke: { width: 0, color: '#000000' }
                },
                opacity: {
                    value: 0.8,
                    random: true, // 透明度随机
                    anim: { enable: false }
                },
                size: {
                    value: 5,
                    random: true, // 大小随机
                    anim: { enable: false }
                },
                line_linked: {
                    enable: false // 关闭连线
                },
                move: {
                    enable: true,
                    speed: 3, // 下落速度
                    direction: 'bottom', // 方向向下
                    random: true, // 随机左右飘动
                    straight: false,
                    out_mode: 'out',
                    bounce: false
                }
            },
            interactivity: {
                detect_on: 'canvas',
                events: {
                    onhover: { enable: false },
                    onclick: { enable: false },
                    resize: true
                }
            },
            retina_detect: true
        });
    }
});